/*	Renegade Scripts.dll
	SSGM crate scripts
	Copyright 2007 Vloktboky, WhiteDragon(MDB), Mac, Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/

#ifndef CRATE_H
#define CRATE_H

#include "gmsettingsclass.h"


//Crate specific settings
struct CrateSettings : public virtual SettingsLoader {
	CrateSettings(const char *ININame) : SettingsLoader(ININame) {
		EnableCrates = false;
		EnableNewCrates = false;
		VehCrate = false;
		CrateVehSpawnPos[0] = Vector3(0,0,0);
		CrateVehSpawnPos[1] = Vector3(0,0,0);
	}

	virtual void Load();

	//Settings added in 1.3.4
	bool EnableCrates;
	//Settings added in 1.4
	bool EnableNewCrates;
	bool VehCrate;
	//Settings added in 1.6
	Vector3	CrateVehSpawnPos[2];
	int	CrateWeapon;
	int	CrateMoney;	
	int	CratePoints;
	int	CrateVehicle;
	int	CrateDeath;
	int	CrateTiberium;
	int	CrateAmmo;
	int	CrateArmor;
	int	CrateHealth;
	int	CrateCharacter;
	int	CrateButterFingers;
	int	CrateRefill;
	int	CrateBeacon;
	int	CrateSpy;
	int	CrateStealth;
	int	CrateThief;
};

//Crate specific data
struct CrateData {
	CrateData() {
		CrateExists = false;
		CrateLastPickup = -181;
		CrateID = 0;
	}
	bool CrateExists;
	int	CrateLastPickup;
	int CrateID;
};

void Crate_Level_Loaded();


//******************************************************************************
//*************************** CRATE RELATED SCRIPTS ****************************
//******************************************************************************


//Attached to all crates.
class MDB_SSGM_Crate : public ScriptImpClass {
	void Created(GameObject *obj);
	void Custom(GameObject *obj, int message, int param, GameObject *sender);
	int vehBlocker;
	bool PickedUp;
};

class KAK_Prevent_Destruction_Until_Entered : public ScriptImpClass {
	void Created(GameObject *obj);
	void Damaged(GameObject *obj, GameObject *damager, float damage);
	void Custom(GameObject *obj, int message, int param, GameObject *sender);
	void Timer_Expired(GameObject *obj, int number);
};

#endif
